#!/bin/bash


task_name=name #add your task name
defense='' #add the defense you want to run
param='' #add the parameters for the defense
type='' #keep empty for a black-box attack '--attack_through' for a white-box attack
eps='' #add the epsilon values you want to run e. g. '4/255 8/255 16/255'
attack='' #add the attack you want to run
attack_steps=10 #add the number of attack steps you want to run
model='ResNet50' #add the model you want to run
output='results/exp_number_n/' #add the output folder
mkdir -p $output

start_time=$(date +%s)
echo "Running task $task_name with defense: $defense, param: $param, type: $type, eps: $eps"
echo "GPU & CUDA info"
nvcc --version
nvidia-smi
echo "=============================================================="
source /conda.sh #path to your conda.sh
conda activate #add your conda environment

python run_experiment.py \
    --epsilons $eps \
    --attack=$attack \
    --attack_steps=$attack_steps  \
    --output=$output'_'$task_name'__include_information_on_experiment__' \
    --save_config \
    --model_attack=$model \
    --defense=$defense \
    --defense_param $param \
    --get_baseline \
    --dataset=imagenet_5000 \ #change to imagenet for the full validation set
    --batch_size=32 \
    $type
    
end_time=$(date +%s)
execution_time=$((end_time - start_time))

echo "Execution time: $execution_time seconds"
echo "finished"